<?php

class UtilParams {
	
	
	// sanitiza bool. 
	// si sigue vacio (null en este caso), le asigna un valor por defecto sino es valido
	public static function sanitizeBool($param, $defaultValue = '0')
	{
		$param = trim($param);
		$param = filter_var($param, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);

		if ($param === null )
		{
			die("Error: Parámetros inválidos. $param"); 
		}

		return $param;
	}

	public static function sanitizeInt($param)
	{
		$param = trim($param);
		
		$param = filter_var($param, FILTER_VALIDATE_INT, FILTER_NULL_ON_FAILURE);
		if ($param === null )
		{
			die("Error: Parámetros inválidos. $param"); 
		}

		return $param;
	}
	
	public static function sanitizeString($param)
	{
		$param = trim($param);
		$param = htmlspecialchars($param, ENT_QUOTES, 'UTF-8');
		return $param;
	}

	public static function validateDate($date, $format = 'Y-m-d')
	{
		$d = DateTime::createFromFormat($format, $date);
		return ($d && $d->format($format) === $date) ? $date : null;
	}


	// sanitizamos un nombre de fichero
	// no queremos que el usuario ponga rutas raras para evitar path traversal
	public static function sanitizeFileName ($filename) {
		$filename = trim($filename);
		$filename = basename($filename); // eliminas rutas
		$filename = pathinfo($filename, PATHINFO_FILENAME); // elimina extension
		$filename = preg_replace('/[^a-zA-Z0-9_-]/', '', $filename); // eliminar caracteres peligrosos para evitar ataques (Ej: ../../, comandos, etc.)

		// si sigue vacio le asignamos un valor por defecto
		if (empty($filename)) { $filename = 'filename'; }

		return $filename;
	}


	public static function sanitizeFileINI ($filename) {
		$filename = trim($filename);
		$filename = basename($filename);
		$filename = pathinfo($filename, PATHINFO_FILENAME);
		$filename = preg_replace('/[^a-zA-Z0-9_-]/', '', $filename);
		$filename = $filename . ".ini";


		return $filename;
	}

	// Función para sanitizar la lista 'sts' (valores separados por comas)
	public static function sanitizeSTS($sts) {
		$sts = trim($sts);
		$stsArray = explode(',', $sts);

		// Filtrar solo los valores numéricos
		$stsArray = array_filter($stsArray, function($value) {
			return is_numeric($value) && (int)$value == $value;
		});

		return implode(',', $stsArray);
	}	


	
	public static function sanitizeAndValidate($key, $value, $type)
	{
		$value = trim($value); // Eliminar espacios en blanco
    
		switch ($type) {
			case 'date':
				return self::validateDate($value) ? $value : die("Error: Fecha inválida para $key , formato deseado Y-m-d ");
        
			case 'list':
				return self::sanitizeSts($value);

			case 'string':
				return self::sanitizeString($value);

			case 'bool':
				return self::sanitizeBool($value);

			case 'int':
				return self::sanitizeInt($value);

			case 'fileName':
				return self::sanitizeFileName($value);

			case 'fileINI':
				return self::sanitizeFileINI($value);

			case 'sts':
				return self::sanitizeSTS($value);
        
        default:
            die("Error: Tipo de dato no reconocido para $key");
    }
}	




}
?>
